	% Example 9.5 LP Cauer
	clear all
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	% Requirements for the digital lowpass filter
	wcT = 0.4*pi;
	wsT = 0.5*pi;
	Amax = 0.1;
	Amin = 60;
	
	% Requirements for the analog prototype lowpass filter
	T = 1;
	wac = (2/T)*tan(wcT/2);
	was = (2/T)*tan(wsT/2);
	
	% Design of the analog prototype lowpass filter (Cauer)
	N = CA_ORDER_S(wac, was, Amax, Amin)
	N = 7;	% We must select an integer order
	[Ga, Za, R_ZEROS, Pa, wsnew] = CA_POLES_S(wac, was, Amax, Amin, N)
	
	% Transformation of the analog prototype filter into the digital filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T)
	figure(1)
	PLOT_PZ_Z(Z, P)
	
	% Computation of attenuation and group delay
	wT = linspace(0, pi, 1000);
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	figure(2)
	axis_Amax = 80;
	axis_Tg_max = 40;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.3, 10.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.6, 25,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
	
